//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#include <sql.h>
//#include <sqlext.h>
//#include <sqltypes.h>
//#include <odbcss.h>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HENV henv;
HDBC hdbc;
BOOL DBOpen = FALSE;

#define MAXBUFLEN 255

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL OpenDB(char *Driver, char *Server, char *UID, char *PWD, char *Database)
{
    BOOL ReturnVal = FALSE;
    RETCODE Result;

    if(SQLAllocEnv(&henv)==SQL_SUCCESS)
    {
        /*allocate the connection handle*/
        if(SQLAllocConnect(henv, &hdbc)==SQL_SUCCESS)
        {
            /* Set login timeout to 5 seconds. */
            SQLSetConnectOption(hdbc, SQL_LOGIN_TIMEOUT, 5);
            SQLSetConnectOption(hdbc, SQL_CURSOR_TYPE, SQL_CURSOR_STATIC);

            char ConnStrIn[MAXBUFLEN];
            sprintf(ConnStrIn, "DRIVER=%s; SERVER=%s; UID=%s; PWD=%s; DATABASE=%s;", Driver, Server, UID, PWD, Database);

            SQLCHAR      ConnStrOut[MAXBUFLEN];
            SQLSMALLINT   cbConnStrOut = 0;

            Result = SQLDriverConnect(
                    hdbc,              // Connection handle
                    NULL,              // Window handle
                    (SQLCHAR *)ConnStrIn,// Input connect string
                    SQL_NTS,           // Null-terminated string
                    ConnStrOut,        // Address of output buffer
                    MAXBUFLEN,         // Size of output buffer
                    &cbConnStrOut,     // Address of output length
                    SQL_DRIVER_NOPROMPT
                );

                if(Result == SQL_ERROR)
                    ReturnVal = FALSE;
//                  printf("Connect Failed.\n");

               if (Result == SQL_SUCCESS || Result == SQL_SUCCESS_WITH_INFO)
                    ReturnVal = TRUE;
//                  printf("Connect Success.\n");
        }
        else SQLFreeConnect(hdbc);
    }
    else SQLFreeEnv(henv);

    DBOpen = ReturnVal;

    return ReturnVal;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DBclose(void)
{
    if(DBOpen)
    {
        SQLDisconnect(hdbc);
        SQLFreeConnect(hdbc);
        SQLFreeEnv(henv);
    }

    DBOpen = FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL DBexecute(char *sql, HSTMT *hstmt)
{
    RETCODE Result;

    if(SQLAllocStmt(hdbc, hstmt)== SQL_SUCCESS)
    {
        Result=SQLPrepare(*hstmt,(unsigned char *)sql,strlen(sql));
        if(Result==SQL_SUCCESS)
        {
            Result=SQLExecute(*hstmt);
            if(Result==SQL_SUCCESS)
            {
                return TRUE;
            }
        }
    }

    return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void DBcloseCursor(HSTMT hstmt)
{
    SQLFreeStmt(hstmt, SQL_DROP);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

